document.addEventListener('DOMContentLoaded', function () {
    // Team Filter Logic
    const filterContainer = document.querySelector('.team-filters');
    if (filterContainer) {
        const filterButtons = filterContainer.querySelectorAll('.btn-filter');
        const teamMembers = document.querySelectorAll('.team-member-card');

        filterButtons.forEach(button => {
            button.addEventListener('click', function () {
                // Update active button state
                filterButtons.forEach(btn => btn.classList.remove('active'));
                this.classList.add('active');

                const filterValue = this.getAttribute('data-filter');

                // Show/hide team members
                teamMembers.forEach(member => {
                    if (filterValue === 'all' || member.dataset.category === filterValue) {
                        member.style.display = 'block';
                    } else {
                        member.style.display = 'none';
                    }
                });
            });
        });
    }

    // Smooth scroll for nav links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            const href = this.getAttribute('href');
            // Check if it's a real anchor link and not just '#'
            if (href.length > 1 && document.querySelector(href)) {
                e.preventDefault();
                document.querySelector(href).scrollIntoView({
                    behavior: 'smooth'
                });
            }
        });
    });
});
